# README: Final Report Generation Script

## 1. Overview

The script leverages a Large Language Model (LLM) guided by a detailed prompt template that embodies the persona of a Principal AI Research Scientist. This ensures that the generated reports are not only structured and articulate but also maintain a high standard of academic and technical rigor, faithfully reflecting the agent's accomplishments and limitations.

## 2. Core Functionality

The script operates by iterating through a set of specified task directories, each corresponding to a unique Question ID (QID). For each QID, it performs the following steps:

1.  **Artifact Aggregation:** It systematically collects all relevant materials from the task directory, including the initial task description, any code files (`*.py`) produced by the agent, and the complete execution logs (`execution.log`).
2.  **Prompt Construction:** It populates a sophisticated, pre-defined prompt template (`REFINEMENT_PROMPT_TEMPLATE`) with the aggregated artifacts. This template instructs the LLM to analyze the materials and structure a formal report.
3.  **LLM Invocation:** It sends the fully constructed prompt to a specified OpenAI-compatible LLM endpoint.
4.  **Output Integration:** The resulting report from the LLM is captured and written back into the `result.json` file within the corresponding QID directory, under the key `"final_answer"`.

### Key Features:
*   **Concurrent Processing:** Utilizes a thread pool (`concurrent.futures.ThreadPoolExecutor`) to process multiple QID directories in parallel, significantly accelerating large-scale batch operations.
*   **Idempotency and Resumption:** The script is designed to be idempotent. It automatically detects QIDs for which a `"final_answer"` has already been generated and skips them, allowing for safe resumption of interrupted batch jobs.

## 3. Prerequisites

### 3.1. Dependencies
Ensure the following Python libraries are installed:
```bash
pip install langchain-openai python-dotenv tqdm
```

### 3.2. Environment Variables
The script requires access to an LLM via an API. Create a `.env` file in the root directory of the project where you will run the script. The file must contain the following keys:

```
# .env.example
OPENAI_API_KEY="your_api_key_here"
OPENAI_API_BASE="your_api_base_url_here"
```

## 4. Input

The script requires a specific directory structure. A root directory must contain subdirectories, where each subdirectory is named with a numeric Question ID (QID).

### Directory Structure:
```
<root_dir>/
├── 1/
│   ├── result.json
│   ├── execution.log
│   ├── agent_script_1.py
│   └── (other generated files...)
├── 2/
│   ├── result.json
│   ├── execution.log
│   └── (other generated files...)
└── .../
```

### Required Files within each QID Directory:

*   **`result.json`**: A JSON file that must contain at least a `"task"` key with the task description string. The script reads from and writes back to this file.
*   **`execution.log`**: A text file containing the `STDOUT` and `STDERR` from the agent's execution run.
*   **`*.py`**: Any Python scripts generated by the agent during its run. These are considered primary deliverables for analysis.

## 5. Output

The script does not create new files. Instead, it **modifies the `result.json` file** within each processed QID directory.

It adds a new key-value pair to the JSON object:
*   **`"final_answer"`**: The value is a long string containing the complete, formatted technical report generated by the LLM.

If a `result.json` file already contains a non-empty `"final_answer"` key, the script will skip that QID directory to avoid redundant processing.

## 6. Usage

The script is executed from the command line and accepts several arguments to configure its behavior.

### Command-Line Interface:
```bash
python <script_name>.py --root_dir <path_to_data> [OPTIONS]
```

### Arguments:

*   `--root_dir` (str, **required**): The path to the root directory containing the QID subfolders.
*   `--qid_start` (int, optional, default: `1`): The starting QID number in the range of tasks to process.
*   `--qid_end` (int, optional, default: `100`): The ending QID number in the range of tasks to process.
*   `--model_name` (str, optional, default: `"deepseek-chat"`): The name of the `ChatOpenAI` model to be used for report generation. This should correspond to a model available at your specified API base.
*   `--max_workers` (int, optional, default: `20`): The maximum number of concurrent threads to use for processing QID folders. Adjust based on your machine's capabilities and API rate limits.

### Example:

To process QIDs from 1 to 150 located in the `./agent_runs` directory, using the `gpt-4-turbo` model with 16 parallel workers, the command would be:
```bash
python report_generator.py --root_dir ./agent_runs --qid_start 1 --qid_end 150 --model_name gpt-4-turbo --max_workers 16
```